/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tramplenomore;

import com.google.common.collect.Iterables;
import java.io.File;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.tramplenomore.Config;
import net.darkhax.tramplenomore.Constants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.state.BlockState;

public class TrampleNoMoreCommon {
    private static final TagKey<Item> SOFT_BOOTS = Services.TAGS.itemTag(new ResourceLocation("tramplenomore", "soft_boots"));
    private static final TagKey<EntityType<?>> CANT_TRAMPLE = Services.TAGS.entityTag(new ResourceLocation("tramplenomore", "prevent_trampling"));
    private static final Config CONFIG = Config.load(new File(Services.PLATFORM.getConfigDirectory(), "tramplenomore.json"));

    public static void init() {
        Constants.LOG.debug("Feather falling enchantment prevents trampling = {}", (Object)TrampleNoMoreCommon.CONFIG.featherFalling);
        Constants.LOG.debug("Items in the soft_boots tag prevent trampling = {}", (Object)TrampleNoMoreCommon.CONFIG.taggedItems);
        Services.EVENTS.addFarmlandTrampleListener(TrampleNoMoreCommon::onTrampleFarmland);
        Services.EVENTS.addRecipeSyncListener(TrampleNoMoreCommon::onRecipesUpdate);
    }

    private static boolean onTrampleFarmland(Entity trampler, BlockPos pos, BlockState state) {
        if (trampler instanceof LivingEntity) {
            ServerPlayer serverPlayer;
            LivingEntity living = (LivingEntity)trampler;
            ItemStack footwear = living.m_6844_(EquipmentSlot.FEET);
            if (!footwear.m_41619_()) {
                if (TrampleNoMoreCommon.CONFIG.taggedItems && footwear.m_204117_(SOFT_BOOTS)) {
                    return true;
                }
                if (TrampleNoMoreCommon.CONFIG.featherFalling && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44967_, (ItemStack)footwear) > 0) {
                    return true;
                }
            }
            if (TrampleNoMoreCommon.CONFIG.creativeMode && living instanceof ServerPlayer && (serverPlayer = (ServerPlayer)living).m_7500_()) {
                return true;
            }
        }
        return TrampleNoMoreCommon.CONFIG.taggedEntities && trampler.m_6095_().m_204039_(CANT_TRAMPLE);
    }

    private static void onRecipesUpdate(RecipeManager manager) {
        Iterable softBoots = Registry.f_122827_.m_206058_(SOFT_BOOTS);
        Constants.LOG.debug("{} contains {} entries.", (Object)SOFT_BOOTS.f_203868_().toString(), (Object)Iterables.size((Iterable)softBoots));
        softBoots.forEach(s -> {
            if (s instanceof Holder.Reference) {
                Holder.Reference holder = (Holder.Reference)s;
                Constants.LOG.debug("{} contains {}.", (Object)SOFT_BOOTS.f_203868_().toString(), (Object)holder.m_205785_().m_135782_().toString());
            }
        });
        Iterable preventedMobs = Registry.f_122826_.m_206058_(CANT_TRAMPLE);
        Constants.LOG.debug("{} contains {} entries.", (Object)CANT_TRAMPLE.f_203868_().toString(), (Object)Iterables.size((Iterable)preventedMobs));
        preventedMobs.forEach(s -> {
            if (s instanceof Holder.Reference) {
                Holder.Reference holder = (Holder.Reference)s;
                Constants.LOG.debug("{} contains {}.", (Object)CANT_TRAMPLE.f_203868_().toString(), (Object)holder.m_205785_().m_135782_().toString());
            }
        });
    }
}

